﻿<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m1="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:ns3="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma" xmlns:ns4="http://www.sec.gov/edgar/mai_drp"
	xmlns:n2="http://www.sec.gov/edgar/maifiler">

	<xsl:template name="JUDGMENT_LIEN_DRP">
		<link href="style.css" rel="stylesheet" type="text/css" />
		<xsl:for-each select="n2:drpInfo/ns4:judgementLienDisclosure/ns4:judgementLienDrp">
	<div id="maiDRPjudg">
  <div class="contentwrapper">
    <h1>JUDGMENT/LIEN DISCLOSURE REPORTING PAGE (MA-I)</h1>
    <h1>JUDGMENT/LIEN DRP PART 1</h1>
    <p>This <b>Disclosure Reporting Page (DRP MA-I)</b> is an 
    <span
						class="label">
						<xsl:choose>
							<xsl:when
								test="count(ns4:baseHeader/ns4:reponseType/m1:add)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<b>INITIAL or</b>
						<xsl:choose>
							<xsl:when
								test="count(ns4:baseHeader/ns4:reponseType/m1:amend) &gt; 0">
							<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<b>AMENDED</b>
					</span>
     response to report details for an affirmative response to <b><em>Question 6M</em></b> on Form MA-I.</p>
	 
	<div class="tableStyle" style="margin-left:0; margin-right:0;">
		<div>
            <div class="tdStyle1 tditem10col1">Is this DRP an amendment that seeks to remove a previously filed DRP concerning the individual from the record?</div>
            <div class="tdStyle1 tditem10col2">             	
					<xsl:choose>
							<xsl:when
								test="ns4:baseHeader/ns4:drpRemovalInfo/ns4:isDrpRemovable= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="ns4:baseHeader/ns4:drpRemovalInfo/ns4:isDrpRemovable= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO 				             
              </div>
          </div><div style="clear:both"></div>
	</div>
	<div class="tableStyle" style="margin-left:0; margin-right:0;">
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">
				The reason the DRP should be removed is:
			</div>
			<div class="tdStyle1 tdTwoCol2">			
				<xsl:choose>
					<xsl:when
						test="count(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isRegistered)&gt; 0">
						<img
							src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img
							src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				The event or <em>proceeding</em> was resolved in the individual's favor<br/>
				<xsl:choose>				
					<xsl:when
						test="count(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isRegistered)&gt; 0">
						<img
							src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img
							src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				The DRP was filed in error.
			</div>
		</div><div style="clear:both"></div>
	</div>
    <p><b><u>How to Report an Event or a Judgment/Lien on a Judgment/Lien DRP</u>:</b> If multiple, unrelated events result in the same affirmative answer, details relating to each separate event must be provided on a separate Judgment/Lien DRP.</p>
    <div class="tableStyle" style="margin-left:0; margin-right:0;">
	<div>
		<div class="tdStyle1 tdTwoCol1">
			<strong><u>DRP on File for This Event</u>:</strong> <u>Is an accurate and up-to-date DRP containing the information regarding the individual required by this DRP already on file (a) in the <em>IARD</em> or <em>CRD</em> system (with a Form ADV, BD, or U4), or (b) in the <em>SEC's</em> EDGAR system (with a Form MA or Form MA-I)?</u>
		</div>
		<div class="tdStyle1 tdTwoCol2">
			<xsl:choose>
				<xsl:when
					  test="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling or ns4:baseHeader/ns4:filingInfo/ns4:maFiling or ns4:baseHeader/ns4:filingInfo/ns4:matFiling or ns4:baseHeader/ns4:filingInfo/ns4:maiFiling">
					  <img src="Images/radio-checked.jpg" alt="radio button checked" />
					  YES
					  <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					  NO
				</xsl:when>
				<xsl:otherwise>
					  <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					  YES
					  <img src="Images/radio-checked.jpg" alt="radio button checked" />
					  NO
				</xsl:otherwise>
		  </xsl:choose>	
		</div>
	</div><div style="clear:both"></div>
</div>
	
     <p><em><u>Note: The filer may identify a DRP filed by the individual directly, or filed by another SEC-registrant about the individual as an associated person.</u></em></p>
	<p>Provide the applicable information indicated below that identifies where the DRP may be found.</p>
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;">
	<div class="tableRow">
		<div class="tdStyle1 tdTwoCol1">
			<xsl:choose>
			<xsl:when
				test="string(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:filingName)">
						
					<img
					src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:otherwise>

					<img
					src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
			</xsl:choose>   
			<b>1. Form ADV, BD, or U4 Filing:</b> For a DRP filed on the <em>IARD</em> or <em>CRD</em> system with one of these forms, provide the following information:
		</div>
	</div><div style="clear:both"></div>
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p>Name on Registration:</p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:filingName)" />
			</div>
		</div><div style="clear:both"></div>
	
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p><em>CRD</em> No.:</p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:crdNumber)" />
			</div>
		</div><div style="clear:both"></div>
	
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p>Disclosure Occurrence No:</p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:disclosureNumber)" />				 
			</div>
		</div><div style="clear:both"></div>
	
	<div class="tableRow">
		<div class="tdStyle1 tdTwoCol1">
			<xsl:choose>
				<xsl:when
					test="string(ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingName)">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
			<xsl:otherwise>
			<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
			</xsl:choose>   
			<b>2. Form MA Filing: </b> For a DRP filed on EDGAR with a Form MA, provide the following information:
		</div>
	</div><div style="clear:both"></div>
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p>Name on Registration:</p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingName)" />
			</div>
		</div><div style="clear:both"></div>
	
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p>MA Registration Number:</p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:registrationNumber)" />
			</div>
		</div><div style="clear:both"></div>
	
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p>Date of filing that contains the DRP (MM/DD/YYYY):</p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingDate)" />
			</div>
		</div><div style="clear:both"></div>
	
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p>Accession number of the filing: </p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:accessionNumber)" />
			</div>
		</div><div style="clear:both"></div>
	
	
	<div class="tableRow">
		<div class="tdStyle1 tdTwoCol1">
			<xsl:choose>
			<xsl:when
					test="string(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingName)">
							
						<img
						src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>

						<img
						src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
			</xsl:choose> 
        <b>3. Form MA-I Filing:</b> For a DRP filed on EDGAR with a Form MA-I, provide the following information:
		</div>
	</div><div style="clear:both"></div>
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p>Name of Individual: </p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingName)" />
			</div>
		</div><div style="clear:both"></div>
	
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p>MA-I File Number:</p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:registrationNumber)" />
			</div>
		</div><div style="clear:both"></div>
	
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p>Date of filing that contains the DRP (MM/DD/YYYY):</p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingDate)" />
			</div>
		</div><div style="clear:both"></div>
	
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p>Accession number of the filing:</p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:accessionNumber)" />
			</div>
		</div><div style="clear:both"></div>
	
	</div>
	   
    <p class="guidance"><b>NOTE:	The completion of all or any part of this form does not relieve the individual or any <em>municipal advisor</em> with which the individual is associated of the obligation to update any relevant Form MA, or <em>IARD</em> or <em>CRD</em> records.</b></p>
    <h1>JUDGMENT/LIEN DRP PART 2</h1>
	<div class="tableStyle" style="margin-left:0; margin-right:0;">
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<b>1. Judgment/Lien Amount: </b>
			</div>
			<div class="tdStyle1 tdTwoCol2">
				<xsl:call-template name="format_to_dollar">
					<xsl:with-param name="money" select="string(ns4:drpData/ns4:judgementOrLienAmout)" /> 			
				</xsl:call-template>
			</div>
		</div><div style="clear:both"></div>
	
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<b>2. Judgment/Lien Holder:</b>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				<xsl:value-of
					select="string(ns4:drpData/ns4:judgementOrLienHolder)"/>			 
			</div>
		</div><div style="clear:both"></div>
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<b>3. Judgment/Lien Type:</b>
			</div>
			<div class="tdStyle1 tdTwoCol2">
				<xsl:choose>
				<xsl:when test="count(ns4:drpData[ns4:judegmentOrLienType='Civil']) &gt; 0">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
					<img
						src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
				Civil
				<xsl:choose>
				<xsl:when
					test="count(ns4:drpData[ns4:judegmentOrLienType='Tax']) &gt; 0">
							<img
						src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
					<img
						src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
				Tax			 
			</div>
		</div><div style="clear:both"></div>
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<b>4. Date Filed (MM/DD/YYYY):</b>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				<xsl:value-of select="string(ns4:drpData/ns4:dateFiled/m1:date)" />			 
			</div>
		</div><div style="clear:both"></div>
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">
				<p></p>
			</div>
			<div class="tdStyle1 tdTwoCol2">
				<xsl:choose>
					<xsl:when
						test="count(ns4:drpData/ns4:dateFiled/m1:exact)&gt; 0">
						<img
							src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img
							src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				Exact				
				<xsl:choose>
					<xsl:when
						test="count(ns4:drpData/ns4:dateFiled/m1:explanationInfo/m1:explanation) &gt; 0">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img
							src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				Explanation			 
			</div>
		</div><div style="clear:both"></div>
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p>If not exact, provide explanation:</p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				<xsl:value-of select="string(ns4:drpData/ns4:dateFiled/m1:explanationInfo/m1:provideExplanation)" />	 
			</div>
		</div><div style="clear:both"></div>
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<b>5. Formal Action Was Brought In:</b>
				<p class="minutia">(<em>If brought in a foreign jurisdiction, provide all the information below in English</em>):</p>
			</div>
			<div class="tdStyle1 tdTwoCol2">
			<p>
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:courtInfo[m1:court='Federal Court']) &gt; 0">
				<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
				</xsl:choose>
			Federal Court</p>
			<p>   
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:courtInfo[m1:court='Military Court']) &gt; 0">
				<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
				</xsl:choose>   
			Military Court</p>
			<p>
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:courtInfo[m1:court='State Court']) &gt; 0">
				<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
				</xsl:choose>
			State Court</p>
			<p>
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:courtInfo[m1:court='Foreign Country Court']) &gt; 0">
				<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
				</xsl:choose>
			Foreign Court</p>
			<p>
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:courtInfo[m1:court='International Court']) &gt; 0">
				<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
				</xsl:choose>
			International Court</p>
			<p>
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:courtInfo[m1:court='Other']) &gt; 0">
				<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
				</xsl:choose>
			Other:
			<br/>
			(specify)</p>	 
			</div>
		</div><div style="clear:both"></div>
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p><b>A. Name of the Court: </b></p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				 <xsl:value-of select="string(ns4:drpData/ns4:courtDetail/ns4:detail/ns4:courtInfo/m1:name)" />
			</div>
		</div><div style="clear:both"></div>
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p><b>B. Location of the Court</b></p>
			</div>
			<div>
				 <p></p>
			</div>
		</div><div style="clear:both"></div>
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p>Street Address: </p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				 <xsl:value-of select="string(ns4:drpData/ns4:courtDetail/ns4:detail/ns4:courtInfo/m1:address/ns1:street1)" />
			</div>
		</div><div style="clear:both"></div>
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p>City or County: </p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				 <xsl:value-of select="string(ns4:drpData/ns4:courtDetail/ns4:detail/ns4:courtInfo/m1:address/ns1:city)" /> 
			</div>
		</div><div style="clear:both"></div>
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p>State/Country:</p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				 <xsl:value-of select="string(ns4:drpData/ns4:courtDetail/ns4:detail/ns4:courtInfo/m1:address/ns1:stateOrCountry)" />
			</div>
		</div><div style="clear:both"></div>
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p>Postal Code: </p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				 <xsl:value-of select="string(ns4:drpData/ns4:courtDetail/ns4:detail/ns4:courtInfo/m1:address/ns1:zipCode)" />
			</div>
		</div><div style="clear:both"></div>
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p><b>C. Docket / Case Name: </b></p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				 <xsl:value-of select="string(ns4:drpData/ns4:courtDetail/ns4:detail/ns4:docketCaseName)" />
			</div>
		</div><div style="clear:both"></div>
	
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p><b>D.  Docket / Case Number: </b></p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				 <xsl:value-of select="string(ns4:drpData/ns4:courtDetail/ns4:detail/ns4:courtInfo/m1:docketOrCaseNo)" />
			</div>
		</div><div style="clear:both"></div>
	
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<b>6. Is Judgment / Lien outstanding?</b>
			</div>
			<div class="tdStyle1 tdTwoCol2">
				 
      <xsl:choose>
		   <xsl:when
		        test="ns4:drpData/ns4:courtDetail/ns4:date">
		        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
		        YES
		        <img src="Images/radio-checked.jpg" alt="radio button checked" />
		        NO
		   </xsl:when>
		   <xsl:when
		        test="not(ns4:drpData/ns4:courtDetail/ns4:date) and (ns4:drpData/ns4:judgementOrLienAmout)">
		        <img src="Images/radio-checked.jpg" alt="radio button checked" />
		        YES
		        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
		        NO
		   </xsl:when>
		   <xsl:otherwise>
		        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
		        YES
		        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
		        NO
		   </xsl:otherwise>
		</xsl:choose>
			  <br />
				If “Yes,” skip to item 8.  If “No,” complete item 7.
			</div>
		</div><div style="clear:both"></div>
	
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<b>7. Provide:</b>
			</div>
			<div>			
				<p></p>
			</div>
		</div><div style="clear:both"></div>
	
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p><b>A. Status Date</b>(MM/DD/YYYY): </p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				 <xsl:value-of select="string(ns4:drpData/ns4:courtDetail/ns4:date/m1:date)" />
			</div>
		</div><div style="clear:both"></div>
	
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">
				<p></p>
			</div>
			<div class="tdStyle1 tdTwoCol2">
				 <xsl:choose>
					<xsl:when
						test="count(ns4:drpData/ns4:courtDetail/ns4:date/m1:exact)&gt; 0">
						<img
							src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img
							src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				<label>Exact</label>
				
				<xsl:choose>
					<xsl:when
						test="count(ns4:drpData/ns4:courtDetail/ns4:date/m1:explanationInfo/m1:explanation) &gt; 0">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img
							src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				<label>Explanation</label>
			</div>
		</div><div style="clear:both"></div>
	
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p>If not exact, provide explanation:</p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				 <xsl:value-of select="string(ns4:drpData/ns4:courtDetail/ns4:date/m1:explanationInfo/m1:provideExplanation)" />
			</div>
		</div><div style="clear:both"></div>
		
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1Label">
				<p><b>B. How was matter resolved? (select appropriate item):</b></p>
			</div>
			<div class="tdStyle1 tdTwoCol2">
				<p><xsl:choose>  
				<xsl:when
					test=" count(ns4:drpData[ns4:matterResolved='Discharged']) &gt; 0">
					<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
					<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
				</xsl:choose>
				Discharged</p>
				<p><xsl:choose>  
				<xsl:when
					test=" count(ns4:drpData[ns4:matterResolved='Released']) &gt; 0">
					<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
					<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
				</xsl:choose>
				Released</p>
				<p><xsl:choose>  
				<xsl:when
					test=" count(ns4:drpData[ns4:matterResolved='Removed']) &gt; 0">
					<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
					<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
				</xsl:choose>
				Removed</p>
				<p><xsl:choose>  
				<xsl:when
					test=" count(ns4:drpData[ns4:matterResolved='Satisfied']) &gt; 0">
					<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
					<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
				</xsl:choose>
				Satisfied</p>
				<p><xsl:choose>  
				<xsl:when
					test=" count(ns4:drpData[ns4:matterResolved='Other']) &gt; 0">
					<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
					<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
				</xsl:choose>
				Other (provide explanation):<br />
				(specify)</p>
			</div>
		</div><div style="clear:both"></div>
	
	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">
				<p></p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				 <xsl:value-of select="string(ns4:drpData/ns4:matterResolvedExplanation)" />
			</div>
		</div><div style="clear:both"></div>
	
	
		<div>
			<div class="tdStyle1 tdTwoCol1Label">
				<b>8. Summary of Circumstances (Optional):</b>
				  <p>
				  You may use this space to provide a brief summary of the circumstances leading to the action as well 
				  as the current status or final disposition. Include any other relevant information.  The information 
				  must fit within the space provided.
				  </p>
			</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				 <xsl:value-of select="string(ns4:baseHeader/ns4:summary)" />
			</div>
		</div><div style="clear:both"></div>
	
	</div>
	
	
    
  </div>
</div>
</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>